﻿/*	VERSION: 	1.0

USAGE: 
	#include "functions/detectRemoval.as"
	detectRemoval( parent_mc, "objName", function(){
		trace("removed");
	});// detectRemoval()
	
	detectRemoval( parent_mc, "objName", destructor_func );
	
*/
function detectRemoval( parentClip_ref, objName_str, destructor_func, pollSpeed_ms ){
	var pollSpeed_ms = pollSpeed_ms || 33;
	var objRef = parentClip_ref[ objName_str ];
	if( !objRef )		return;		// abort if:  There's nothing to track
	
	var isObject = ( objRef instanceof Object );
	
	var interval = setInterval( checkStillExists, pollSpeed_ms );
	function checkStillExists(){
		var objExists = false;
		if( isObject )		objExists = Boolean( parentClip_ref[ objName_str ] === objRef );			// If the object reference is broken
		if( !isObject )		objExists = Boolean( parentClip_ref[ objName_str ] !== undefined );		// if the variable becomes undefined
		
		if( !objExists ){
			destructor_func();
			clearInterval( interval );
		}
	}// checkStillExists()
}// detectRemoval()
